(function() {
    var path = new cavalry.Path();

    // Overlapping trefoil: r = innerRadius + lobeSize * cos(lobes * theta)
    // When lobeSize > innerRadius, the lobes overlap through the centre
    var angleOffset = Math.PI / 2;

    for (var i = 0; i <= segments; i++) {
        var theta = (i / segments) * Math.PI * 2;
        var r = innerRadius + lobeSize * Math.cos(lobes * theta);
        var x = r * Math.cos(theta + angleOffset);
        var y = r * Math.sin(theta + angleOffset);

        if (i === 0) {
            path.moveTo(x, y);
        } else {
            path.lineTo(x, y);
        }
    }
    path.close();

    var mesh = new cavalry.Mesh();
    mesh.addPath(path);
    return mesh;
})();
